<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\Url;

$this->title = 'Регистрация';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="site-register">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h1 class="panel-title text-center"><?= Html::encode($this->title) ?></h1>
                </div>
                <div class="panel-body">
                    <?php $form = ActiveForm::begin([
                        'id' => 'register-form',
                        'options' => ['class' => 'form-horizontal'],
                        'fieldConfig' => [
                            'template' => "{label}\n<div class=\"col-lg-9\">{input}\n{hint}</div>\n<div class=\"col-lg-9 col-lg-offset-3\">{error}</div>",
                            'labelOptions' => ['class' => 'col-lg-3 control-label'],
                        ],
                    ]); ?>

                    <?= $form->field($model, 'username', [
                        'inputOptions' => [
                            'placeholder' => 'Только латиница и цифры (min 6 символов)',
                            'class' => 'form-control'
                        ]
                    ])->hint('Например: user123') ?>

                    <?= $form->field($model, 'password', [
                        'inputOptions' => [
                            'placeholder' => 'Минимум 8 символов',
                            'class' => 'form-control'
                        ]
                    ])->passwordInput() ?>

                    <?= $form->field($model, 'password_repeat', [
                        'inputOptions' => [
                            'placeholder' => 'Повторите пароль',
                            'class' => 'form-control'
                        ]
                    ])->passwordInput() ?>

                    <?= $form->field($model, 'full_name', [
                        'inputOptions' => [
                            'placeholder' => 'Иванов Иван Иванович',
                            'class' => 'form-control'
                        ]
                    ])->hint('Только кириллические символы и пробелы') ?>

                    <?= $form->field($model, 'phone', [
                        'inputOptions' => [
                            'placeholder' => '8(999)123-45-67',
                            'class' => 'form-control'
                        ]
                    ])->hint('Формат: 8(XXX)XXX-XX-XX') ?>

                    <?= $form->field($model, 'email', [
                        'inputOptions' => [
                            'placeholder' => 'example@mail.ru',
                            'class' => 'form-control',
                            'type' => 'email'
                        ]
                    ]) ?>

                    <div class="form-group">
                        <div class="col-lg-offset-3 col-lg-9">
                            <?= Html::submitButton('Создать пользователя', [
                                'class' => 'btn btn-success btn-block',
                                'name' => 'register-button'
                            ]) ?>
                        </div>
                    </div>

                    <?php ActiveForm::end(); ?>
                    
                    <div class="text-center">
                        <p>Уже зарегистрированы? 
                            <?= Html::a('Войдите в систему', ['site/login']) ?>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.site-register {
    padding-top: 30px;
}
.panel {
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}
.help-block {
    font-size: 12px;
    color: #666;
}
</style>

<?php
// JavaScript для маски телефона
$this->registerJs("
    $(document).ready(function() {
        $('#user-phone').inputmask('8(999)999-99-99');
        
        // AJAX валидация формы
        $('#register-form').on('beforeSubmit', function(e) {
            var form = $(this);
            $.ajax({
                url: form.attr('action'),
                type: 'POST',
                data: form.serialize(),
                success: function(data) {
                    if(data.success) {
                        // Форма успешно отправлена
                        window.location.href = '" . Url::to(['site/login']) . "';
                    } else if(data.validation) {
                        // Отображаем ошибки валидации
                        $.each(data.validation, function(attribute, messages) {
                            var input = form.find('#user-' + attribute);
                            var errorContainer = input.closest('.form-group').find('.help-block-error');
                            errorContainer.html(messages.join('<br>'));
                        });
                    }
                }
            });
            return false;
        });
    });
");
?>