<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\Url;

$this->title = 'Авторизация';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="site-login">
    <div class="row">
        <div class="col-md-6 col-md-offset-3">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h1 class="panel-title text-center"><?= Html::encode($this->title) ?></h1>
                </div>
                <div class="panel-body">
                    <?php $form = ActiveForm::begin([
                        'id' => 'login-form',
                        'options' => ['class' => 'form-horizontal'],
                        'fieldConfig' => [
                            'template' => "{label}\n<div class=\"col-lg-9\">{input}</div>\n<div class=\"col-lg-9 col-lg-offset-3\">{error}</div>",
                            'labelOptions' => ['class' => 'col-lg-3 control-label'],
                        ],
                    ]); ?>

                    <?= $form->field($model, 'username')->textInput([
                        'autofocus' => true,
                        'placeholder' => 'Введите ваш логин'
                    ]) ?>

                    <?= $form->field($model, 'password')->passwordInput([
                        'placeholder' => 'Введите ваш пароль'
                    ]) ?>

                    <?= $form->field($model, 'rememberMe')->checkbox([
                        'template' => "<div class=\"col-lg-offset-3 col-lg-9\">{input} {label}</div>\n<div class=\"col-lg-8\">{error}</div>",
                    ]) ?>

                    <div class="form-group">
                        <div class="col-lg-offset-3 col-lg-9">
                            <?= Html::submitButton('Войти', [
                                'class' => 'btn btn-primary btn-block',
                                'name' => 'login-button'
                            ]) ?>
                        </div>
                    </div>

                    <?php ActiveForm::end(); ?>
                    
                    <div class="text-center">
                        <p>Еще не зарегистрированы? 
                            <?= Html::a('Зарегистрируйтесь', ['site/register']) ?>
                        </p>
                        
                        <p>Тестовый доступ для администратора:<br>
                            <small>Логин: <strong>Admin</strong><br>
                            Пароль: <strong>KorokNET</strong></small>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.site-login {
    padding-top: 50px;
}
.panel {
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}
</style>