<?php

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Мои заявки';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="application-index">
    <h1><?= Html::encode($this->title) ?></h1>

    <div class="mb-4">
        <?= Html::a('Подать новую заявку', ['create'], ['class' => 'btn btn-success']) ?>
        <?= Html::a('Просмотреть курсы', ['/site/courses'], ['class' => 'btn btn-primary']) ?>
    </div>

    <?php if (empty($applications)): ?>
        <div class="alert alert-info">
            <h4>У вас пока нет заявок</h4>
            <p>Вы еще не подавали заявок на обучение. <?= Html::a('Создайте первую заявку', ['create']) ?>.</p>
        </div>
    <?php else: ?>
        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Курс</th>
                        <th>Дата начала</th>
                        <th>Способ оплаты</th>
                        <th>Статус</th>
                        <th>Дата подачи</th>
                        <th>Действия</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($applications as $application): ?>
                    <tr>
                        <td><?= $application->id ?></td>
                        <td>
                            <strong><?= Html::encode($application->course_name) ?></strong>
                        </td>
                        <td>
                            <?= Yii::$app->formatter->asDate($application->desired_start_date, 'long') ?>
                        </td>
                        <td>
                            <?= $application->payment_method == 'cash' ? 'Наличными' : 'Переводом по номеру телефона' ?>
                        </td>
                        <td>
                            <span class="badge <?= 
                                $application->status == 'new' ? 'badge-primary' : 
                                ($application->status == 'in_progress' ? 'badge-warning' : 'badge-success')
                            ?>">
                                <?= $application->status == 'new' ? 'Новая' : 
                                   ($application->status == 'in_progress' ? 'Идет обучение' : 'Обучение завершено') ?>
                            </span>
                        </td>
                        <td>
                            <?= Yii::$app->formatter->asDatetime($application->created_at, 'short') ?>
                        </td>
                        <td>
                            <div class="btn-group btn-group-sm">
                                <?= Html::a('Просмотр', ['view', 'id' => $application->id], [
                                    'class' => 'btn btn-info',
                                    'title' => 'Подробная информация о заявке'
                                ]) ?>
                                
                                <?php if ($application->status == 'completed' && empty($application->feedback)): ?>
                                    <?= Html::a('Отзыв', ['feedback', 'id' => $application->id], [
                                        'class' => 'btn btn-warning',
                                        'title' => 'Оставить отзыв о курсе'
                                    ]) ?>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        
        <div class="alert alert-light mt-3">
            <h5>Статусы заявок:</h5>
            <div>
                <span class="badge badge-primary">Новая</span> - заявка подана и ожидает рассмотрения<br>
                <span class="badge badge-warning">Идет обучение</span> - заявка одобрена, обучение началось<br>
                <span class="badge badge-success">Обучение завершено</span> - курс пройден, можно оставить отзыв
            </div>
        </div>
    <?php endif; ?>
</div>

<style>
.badge {
    padding: 5px 10px;
    border-radius: 4px;
}
.badge-primary {
    background-color: #007bff;
    color: white;
}
.badge-warning {
    background-color: #ffc107;
    color: #212529;
}
.badge-success {
    background-color: #28a745;
    color: white;
}
.table {
    margin-top: 20px;
}
</style>