<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Отзыв о курсе: ' . $model->course_name;
$this->params['breadcrumbs'][] = ['label' => 'Мои заявки', 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => 'Заявка #' . $model->id, 'url' => ['view', 'id' => $model->id]];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="application-feedback">
    <h1><?= Html::encode($this->title) ?></h1>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <div class="alert alert-success">
                        <h5>Поздравляем с завершением курса!</h5>
                        <p class="mb-0">Пожалуйста, оставьте ваш отзыв о качестве образовательных услуг.</p>
                    </div>

                    <?php $form = ActiveForm::begin([
                        'id' => 'feedback-form',
                    ]); ?>

                    <div class="mb-4">
                        <label class="form-label"><strong>Оцените курс (от 1 до 5):</strong></label>
                        <div>
                            <?php for ($i = 1; $i <= 5; $i++): ?>
                                <div style="display: inline-block; margin-right: 15px;">
                                    <input type="radio" 
                                           name="Application[rating]" 
                                           id="rating<?= $i ?>" 
                                           value="<?= $i ?>"
                                           <?= ($model->rating == $i) ? 'checked' : '' ?>
                                           required>
                                    <label for="rating<?= $i ?>" style="margin-left: 5px;">
                                        <?= $i ?>
                                        <?php for ($j = 1; $j <= $i; $j++): ?>
                                            <span style="color: #ffc107;">★</span>
                                        <?php endfor; ?>
                                    </label>
                                </div>
                            <?php endfor; ?>
                        </div>
                        <?php if ($model->hasErrors('rating')): ?>
                            <div class="text-danger">
                                <?= implode(', ', $model->getErrors('rating')) ?>
                            </div>
                        <?php endif; ?>
                    </div>

                    <?= $form->field($model, 'feedback')->textarea([
                        'rows' => 6,
                        'placeholder' => 'Поделитесь вашими впечатлениями о курсе. Что понравилось? Что можно улучшить?',
                        'class' => 'form-control'
                    ])->label('Ваш отзыв*') ?>

                    <div class="form-group">
                        <?= Html::submitButton('Отправить отзыв', [
                            'class' => 'btn btn-success btn-lg',
                            'name' => 'feedback-button'
                        ]) ?>
                        
                        <?= Html::a('Отмена', ['view', 'id' => $model->id], [
                            'class' => 'btn btn-secondary'
                        ]) ?>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Информация о курсе</h5>
                </div>
                <div class="card-body">
                    <h6><?= Html::encode($model->course_name) ?></h6>
                    <ul class="list-unstyled">
                        <li><strong>Дата начала:</strong> <?= Yii::$app->formatter->asDate($model->desired_start_date, 'long') ?></li>
                        <li><strong>Статус:</strong> 
                            <span class="badge badge-success">Обучение завершено</span>
                        </li>
                        <li><strong>Дата подачи:</strong> <?= Yii::$app->formatter->asDate($model->created_at, 'long') ?></li>
                    </ul>
                    
                    <hr>
                    
                    <div class="alert alert-info">
                        <h6>Полезные советы:</h6>
                        <ul class="small mb-0">
                            <li>Будьте объективны и честны в оценке</li>
                            <li>Укажите сильные и слабые стороны курса</li>
                            <li>Отзыв поможет улучшить качество обучения</li>
                            <li>После отправки отзыв нельзя будет изменить</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>