<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;

$this->title = 'Подача заявки на обучение';
$this->params['breadcrumbs'][] = ['label' => 'Мои заявки', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

// Получаем список курсов
$coursesList = ArrayHelper::map($courses, 'id', function($course) {
    return $course->name . ' (' . Yii::$app->formatter->asCurrency($course->price) . ', ' . $course->duration_hours . ' часов)';
});
?>
<div class="application-create">
    <h1><?= Html::encode($this->title) ?></h1>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <p class="text-muted mb-4">
                        Заполните форму для подачи заявки на обучение. После отправки заявка поступит на рассмотрение администратору.
                    </p>

                    <?php $form = ActiveForm::begin([
                        'id' => 'application-form',
                    ]); ?>

                    <?= $form->field($model, 'course_id')->dropDownList(
                        $coursesList,
                        [
                            'prompt' => '-- Выберите курс --',
                            'class' => 'form-control',
                            'id' => 'course-select'
                        ]
                    )->label('Курс*') ?>

                    <?= $form->field($model, 'desired_start_date')->textInput([
                        'type' => 'date',
                        'class' => 'form-control',
                    ])->label('Желаемая дата начала*')
                    ->hint('Выберите дату не ранее завтрашнего дня и не позднее чем через год') ?>

                    <?= $form->field($model, 'payment_method')->radioList(
                        [
                            'cash' => 'Наличными',
                            'transfer' => 'Переводом по номеру телефона',
                        ],
                        [
                            'class' => 'list-unstyled'
                        ]
                    )->label('Способ оплаты*') ?>

                    <div class="form-group">
                        <?= Html::submitButton('Отправить заявку', [
                            'class' => 'btn btn-success btn-lg',
                            'name' => 'application-button'
                        ]) ?>
                        
                        <?= Html::a('Отмена', ['index'], [
                            'class' => 'btn btn-secondary'
                        ]) ?>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Информация о курсах</h5>
                </div>
                <div class="card-body">
                    <?php if (!empty($courses)): ?>
                        <div class="list-group">
                            <?php foreach ($courses as $course): ?>
                                <div class="list-group-item">
                                    <h6 class="mb-1"><?= Html::encode($course->name) ?></h6>
                                    <small class="text-muted">
                                        <?= $course->duration_hours ?> часов • 
                                        <?= Yii::$app->formatter->asCurrency($course->price) ?>
                                    </small>
                                    <?php if ($course->description): ?>
                                        <p class="mb-0 small mt-1"><?= Html::encode(mb_substr($course->description, 0, 100)) ?>...</p>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php else: ?>
                        <p class="text-muted">Нет доступных курсов</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.card {
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    margin-bottom: 20px;
}
.list-group-item {
    border-left: none;
    border-right: none;
}
.list-group-item:first-child {
    border-top: none;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Устанавливаем минимальную дату (завтра)
    const dateInput = document.querySelector('input[type="date"]');
    if (dateInput) {
        const tomorrow = new Date();
        tomorrow.setDate(tomorrow.getDate() + 1);
        const maxDate = new Date();
        maxDate.setFullYear(maxDate.getFullYear() + 1);
        
        // Форматируем даты для input[type="date"]
        dateInput.min = tomorrow.toISOString().split('T')[0];
        dateInput.max = maxDate.toISOString().split('T')[0];
        
        // Устанавливаем дату по умолчанию (через неделю)
        const defaultDate = new Date();
        defaultDate.setDate(defaultDate.getDate() + 7);
        dateInput.value = defaultDate.toISOString().split('T')[0];
    }
});
</script>