<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

$this->title = 'Пользователь: ' . $model->full_name;
$this->params['breadcrumbs'][] = ['label' => 'Пользователи', 'url' => ['users']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="admin-view-user">
    <div class="row">
        <div class="col-md-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1><?= Html::encode($this->title) ?></h1>
                <div class="btn-group">
                    <?= Html::a('<i class="glyphicon glyphicon-arrow-left"></i> Назад', ['users'], ['class' => 'btn btn-default']) ?>
                    <?= Html::a('<i class="glyphicon glyphicon-edit"></i> Редактировать', ['update-user', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
                    <?= Html::a('<i class="glyphicon glyphicon-envelope"></i> Отправить сообщение', ['#'], ['class' => 'btn btn-info']) ?>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-4">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Основная информация</h3>
                </div>
                <div class="panel-body">
                    <?= DetailView::widget([
                        'model' => $model,
                        'attributes' => [
                            'id',
                            'username',
                            'full_name',
                            'phone',
                            'email',
                            [
                                'attribute' => 'role',
                                'value' => function($model) {
                                    return $model->isAdmin() ? 
                                        '<span class="label label-danger">Администратор</span>' : 
                                        '<span class="label label-primary">Пользователь</span>';
                                },
                                'format' => 'raw',
                            ],
                            [
                                'attribute' => 'created_at',
                                'format' => 'datetime',
                                'label' => 'Дата регистрации',
                            ],
                            [
                                'attribute' => 'updated_at',
                                'format' => 'datetime',
                                'label' => 'Дата обновления',
                            ],
                        ],
                    ]) ?>
                </div>
            </div>
            
            <div class="panel panel-warning">
                <div class="panel-heading">
                    <h3 class="panel-title">Статистика</h3>
                </div>
                <div class="panel-body">
                    <table class="table">
                        <tr>
                            <td>Всего заявок:</td>
                            <td><strong><?= $model->getApplicationsCount() ?></strong></td>
                        </tr>
                        <tr>
                            <td>Новых заявок:</td>
                            <td>
                                <strong>
                                    <?= \app\models\Application::find()
                                        ->where(['user_id' => $model->id, 'status' => \app\models\Application::STATUS_NEW])
                                        ->count() ?>
                                </strong>
                            </td>
                        </tr>
                        <tr>
                            <td>В процессе:</td>
                            <td>
                                <strong>
                                    <?= \app\models\Application::find()
                                        ->where(['user_id' => $model->id, 'status' => \app\models\Application::STATUS_IN_PROGRESS])
                                        ->count() ?>
                                </strong>
                            </td>
                        </tr>
                        <tr>
                            <td>Завершено:</td>
                            <td>
                                <strong>
                                    <?= \app\models\Application::find()
                                        ->where(['user_id' => $model->id, 'status' => \app\models\Application::STATUS_COMPLETED])
                                        ->count() ?>
                                </strong>
                            </td>
                        </tr>
                        <tr>
                            <td>Оставлено отзывов:</td>
                            <td>
                                <strong>
                                    <?= \app\models\Application::find()
                                        ->where(['user_id' => $model->id])
                                        ->andWhere(['not', ['feedback' => null]])
                                        ->count() ?>
                                </strong>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
        
        <div class="col-md-8">
            <div class="panel panel-primary">
                <div class="panel-heading">
                    <h3 class="panel-title">Заявки пользователя</h3>
                </div>
                <div class="panel-body">
                    <?php if (empty($userApplications)): ?>
                        <p class="text-muted">У пользователя нет заявок</p>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Курс</th>
                                        <th>Дата начала</th>
                                        <th>Статус</th>
                                        <th>Дата подачи</th>
                                        <th>Действия</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($userApplications as $application): ?>
                                    <tr>
                                        <td><?= $application->id ?></td>
                                        <td><?= Html::encode($application->course_name) ?></td>
                                        <td><?= Yii::$app->formatter->asDate($application->desired_start_date) ?></td>
                                        <td>
                                            <span class="label label-<?= $application->statusColor ?>">
                                                <?= $application->statusLabel ?>
                                            </span>
                                        </td>
                                        <td><?= Yii::$app->formatter->asDate($application->created_at, 'short') ?></td>
                                        <td>
                                            <?= Html::a('<i class="glyphicon glyphicon-eye-open"></i>', 
                                                ['view-application', 'id' => $application->id], 
                                                ['class' => 'btn btn-xs btn-info', 'title' => 'Просмотр']) ?>
                                            <?= Html::a('<i class="glyphicon glyphicon-edit"></i>', 
                                                ['update-status', 'id' => $application->id], 
                                                ['class' => 'btn btn-xs btn-warning', 'title' => 'Изменить статус']) ?>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="panel panel-success">
                <div class="panel-heading">
                    <h3 class="panel-title">Отзывы пользователя</h3>
                </div>
                <div class="panel-body">
                    <?php 
                    $feedbacks = \app\models\Application::find()
                        ->where(['user_id' => $model->id])
                        ->andWhere(['not', ['feedback' => null]])
                        ->with('course')
                        ->all();
                    ?>
                    
                    <?php if (empty($feedbacks)): ?>
                        <p class="text-muted">Пользователь еще не оставлял отзывы</p>
                    <?php else: ?>
                        <?php foreach ($feedbacks as $feedback): ?>
                            <div class="well">
                                <div class="d-flex justify-content-between">
                                    <h5>
                                        <?= Html::a(Html::encode($feedback->course_name), 
                                            ['view-application', 'id' => $feedback->id]) ?>
                                    </h5>
                                    <div>
                                        <?php for ($i = 1; $i <= 5; $i++): ?>
                                            <?php if ($i <= $feedback->rating): ?>
                                                <i class="glyphicon glyphicon-star text-warning"></i>
                                            <?php else: ?>
                                                <i class="glyphicon glyphicon-star-empty text-muted"></i>
                                            <?php endif; ?>
                                        <?php endfor; ?>
                                        <span class="text-muted ml-2">(<?= $feedback->rating ?>/5)</span>
                                    </div>
                                </div>
                                <p><?= nl2br(Html::encode($feedback->feedback)) ?></p>
                                <small class="text-muted">
                                    <?= Yii::$app->formatter->asDatetime($feedback->updated_at) ?>
                                </small>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>