<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

$this->title = 'Курс: ' . $model->name;
$this->params['breadcrumbs'][] = ['label' => 'Курсы', 'url' => ['courses']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="admin-view-course">
    <div class="row">
        <div class="col-md-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1><?= Html::encode($this->title) ?></h1>
                <div class="btn-group">
                    <?= Html::a('<i class="glyphicon glyphicon-arrow-left"></i> Назад', ['courses'], ['class' => 'btn btn-default']) ?>
                    <?= Html::a('<i class="glyphicon glyphicon-edit"></i> Редактировать', ['update-course', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
                    <?= Html::a('<i class="glyphicon glyphicon-trash"></i> Удалить', ['delete-course', 'id' => $model->id], [
                        'class' => 'btn btn-danger',
                        'data' => [
                            'confirm' => 'Вы уверены, что хотите удалить этот курс?',
                            'method' => 'post',
                        ],
                    ]) ?>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Основная информация</h3>
                </div>
                <div class="panel-body">
                    <?= DetailView::widget([
                        'model' => $model,
                        'attributes' => [
                            'id',
                            'name',
                            [
                                'attribute' => 'description',
                                'value' => $model->description ?: 'Не указано',
                                'format' => 'ntext',
                            ],
                            [
                                'attribute' => 'duration_hours',
                                'value' => $model->formattedDuration,
                            ],
                            [
                                'attribute' => 'price',
                                'value' => $model->formattedPrice,
                            ],
                            [
                                'attribute' => 'is_active',
                                'value' => function($model) {
                                    return $model->is_active ? 
                                        '<span class="label label-success">Активен</span>' : 
                                        '<span class="label label-danger">Не активен</span>';
                                },
                                'format' => 'raw',
                            ],
                            [
                                'attribute' => 'created_at',
                                'format' => 'datetime',
                                'label' => 'Дата создания',
                            ],
                            [
                                'attribute' => 'updated_at',
                                'format' => 'datetime',
                                'label' => 'Дата обновления',
                            ],
                        ],
                    ]) ?>
                </div>
            </div>
            
            <div class="panel panel-warning">
                <div class="panel-heading">
                    <h3 class="panel-title">Статистика курса</h3>
                </div>
                <div class="panel-body">
                    <table class="table">
                        <tr>
                            <td>Всего заявок:</td>
                            <td><strong><?= $model->getApplicationsCount() ?></strong></td>
                        </tr>
                        <tr>
                            <td>Новых заявок:</td>
                            <td>
                                <strong>
                                    <?= \app\models\Application::find()
                                        ->where(['course_id' => $model->id, 'status' => \app\models\Application::STATUS_NEW])
                                        ->count() ?>
                                </strong>
                            </td>
                        </tr>
                        <tr>
                            <td>В процессе:</td>
                            <td>
                                <strong>
                                    <?= \app\models\Application::find()
                                        ->where(['course_id' => $model->id, 'status' => \app\models\Application::STATUS_IN_PROGRESS])
                                        ->count() ?>
                                </strong>
                            </td>
                        </tr>
                        <tr>
                            <td>Завершено:</td>
                            <td>
                                <strong>
                                    <?= \app\models\Application::find()
                                        ->where(['course_id' => $model->id, 'status' => \app\models\Application::STATUS_COMPLETED])
                                        ->count() ?>
                                </strong>
                            </td>
                        </tr>
                        <tr>
                            <td>Средняя оценка:</td>
                            <td>
                                <strong>
                                    <?php 
                                    $avgRating = \app\models\Application::find()
                                        ->where(['course_id' => $model->id])
                                        ->andWhere(['not', ['rating' => null]])
                                        ->average('rating');
                                    echo $avgRating ? round($avgRating, 2) . '/5' : 'Нет оценок';
                                    ?>
                                </strong>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="panel panel-primary">
                <div class="panel-heading">
                    <h3 class="panel-title">Последние заявки на курс</h3>
                </div>
                <div class="panel-body">
                    <?php if (empty($courseApplications)): ?>
                        <p class="text-muted">На этот курс пока нет заявок</p>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Пользователь</th>
                                        <th>Статус</th>
                                        <th>Дата подачи</th>
                                        <th>Действия</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($courseApplications as $application): ?>
                                    <tr>
                                        <td><?= $application->id ?></td>
                                        <td><?= Html::encode($application->user->full_name) ?></td>
                                        <td>
                                            <span class="label label-<?= $application->statusColor ?>">
                                                <?= $application->statusLabel ?>
                                            </span>
                                        </td>
                                        <td><?= Yii::$app->formatter->asDate($application->created_at, 'short') ?></td>
                                        <td>
                                            <?= Html::a('<i class="glyphicon glyphicon-eye-open"></i>', 
                                                ['view-application', 'id' => $application->id], 
                                                ['class' => 'btn btn-xs btn-info', 'title' => 'Просмотр']) ?>
                                            <?= Html::a('<i class="glyphicon glyphicon-edit"></i>', 
                                                ['update-status', 'id' => $application->id], 
                                                ['class' => 'btn btn-xs btn-warning', 'title' => 'Изменить статус']) ?>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="text-center">
                            <?= Html::a('<i class="glyphicon glyphicon-list"></i> Все заявки на этот курс', 
                                ['applications', 'ApplicationSearch[course_id]' => $model->id], 
                                ['class' => 'btn btn-default']) ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="panel panel-success">
                <div class="panel-heading">
                    <h3 class="panel-title">Отзывы о курсе</h3>
                </div>
                <div class="panel-body">
                    <?php 
                    $feedbacks = \app\models\Application::find()
                        ->where(['course_id' => $model->id])
                        ->andWhere(['not', ['feedback' => null]])
                        ->with('user')
                        ->all();
                    ?>
                    
                    <?php if (empty($feedbacks)): ?>
                        <p class="text-muted">На этот курс пока нет отзывов</p>
                    <?php else: ?>
                        <?php foreach ($feedbacks as $feedback): ?>
                            <div class="well">
                                <div class="d-flex justify-content-between">
                                    <h6><?= Html::encode($feedback->user->full_name) ?></h6>
                                    <div>
                                        <?php for ($i = 1; $i <= 5; $i++): ?>
                                            <?php if ($i <= $feedback->rating): ?>
                                                <i class="glyphicon glyphicon-star text-warning"></i>
                                            <?php else: ?>
                                                <i class="glyphicon glyphicon-star-empty text-muted"></i>
                                            <?php endif; ?>
                                        <?php endfor; ?>
                                        <span class="text-muted ml-2">(<?= $feedback->rating ?>/5)</span>
                                    </div>
                                </div>
                                <p><?= nl2br(Html::encode($feedback->feedback)) ?></p>
                                <small class="text-muted">
                                    <?= Yii::$app->formatter->asDatetime($feedback->updated_at) ?>
                                </small>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>