<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

$this->title = 'Заявка #' . $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Заявки', 'url' => ['applications']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="admin-view-application">
    <div class="row">
        <div class="col-md-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1><?= Html::encode($this->title) ?></h1>
                <div class="btn-group">
                    <?= Html::a('<i class="glyphicon glyphicon-arrow-left"></i> Назад', ['applications'], ['class' => 'btn btn-default']) ?>
                    <?= Html::a('<i class="glyphicon glyphicon-edit"></i> Изменить статус', ['update-status', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
                    <?= Html::a('<i class="glyphicon glyphicon-print"></i> Печать', '#', [
                        'class' => 'btn btn-default',
                        'onclick' => 'window.print(); return false;'
                    ]) ?>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Основная информация</h3>
                </div>
                <div class="panel-body">
                    <?= DetailView::widget([
                        'model' => $model,
                        'attributes' => [
                            'id',
                            [
                                'attribute' => 'user_id',
                                'label' => 'Пользователь',
                                'value' => function($model) {
                                    return $model->user ? 
                                        Html::a($model->user->full_name, ['view-user', 'id' => $model->user->id], ['class' => 'btn btn-link']) : 
                                        'Не указан';
                                },
                                'format' => 'raw',
                            ],
                            [
                                'attribute' => 'course_name',
                                'label' => 'Курс',
                                'value' => function($model) {
                                    return $model->course ? 
                                        Html::a($model->course->name, ['view-course', 'id' => $model->course->id], ['class' => 'btn btn-link']) : 
                                        $model->course_name;
                                },
                                'format' => 'raw',
                            ],
                            [
                                'attribute' => 'desired_start_date',
                                'format' => 'date',
                                'label' => 'Желаемая дата начала',
                            ],
                            [
                                'attribute' => 'payment_method',
                                'value' => $model->paymentMethodLabel,
                                'label' => 'Способ оплаты',
                            ],
                            [
                                'attribute' => 'status',
                                'value' => function($model) {
                                    return '<span class="label label-' . $model->statusColor . '">' . $model->statusLabel . '</span>';
                                },
                                'format' => 'raw',
                                'label' => 'Статус',
                            ],
                            [
                                'attribute' => 'created_at',
                                'format' => 'datetime',
                                'label' => 'Дата подачи',
                            ],
                            [
                                'attribute' => 'updated_at',
                                'format' => 'datetime',
                                'label' => 'Дата обновления',
                            ],
                        ],
                    ]) ?>
                </div>
            </div>
            
            <?php if ($model->feedback): ?>
            <div class="panel panel-success">
                <div class="panel-heading">
                    <h3 class="panel-title">Отзыв пользователя</h3>
                </div>
                <div class="panel-body">
                    <div class="alert alert-success">
                        <div class="d-flex justify-content-between">
                            <strong>Оценка:</strong>
                            <div>
                                <?php for ($i = 1; $i <= 5; $i++): ?>
                                    <?php if ($i <= $model->rating): ?>
                                        <i class="glyphicon glyphicon-star text-warning"></i>
                                    <?php else: ?>
                                        <i class="glyphicon glyphicon-star-empty text-muted"></i>
                                    <?php endif; ?>
                                <?php endfor; ?>
                                <span class="ml-2">(<?= $model->rating ?>/5)</span>
                            </div>
                        </div>
                        <hr>
                        <p><?= nl2br(Html::encode($model->feedback)) ?></p>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
        
        <div class="col-md-4">
            <div class="panel panel-info">
                <div class="panel-heading">
                    <h3 class="panel-title">Информация о пользователе</h3>
                </div>
                <div class="panel-body">
                    <?php if ($model->user): ?>
                        <?= DetailView::widget([
                            'model' => $model->user,
                            'attributes' => [
                                'id',
                                'username',
                                'full_name',
                                'phone',
                                'email',
                                [
                                    'attribute' => 'role',
                                    'value' => function($model) {
                                        return $model->isAdmin() ? 'Администратор' : 'Пользователь';
                                    },
                                ],
                                [
                                    'attribute' => 'created_at',
                                    'format' => 'datetime',
                                    'label' => 'Дата регистрации',
                                ],
                            ],
                        ]) ?>
                        <div class="text-center mt-3">
                            <?= Html::a('<i class="glyphicon glyphicon-user"></i> Профиль пользователя', 
                                ['view-user', 'id' => $model->user->id], 
                                ['class' => 'btn btn-primary']) ?>
                        </div>
                    <?php else: ?>
                        <p class="text-muted">Информация о пользователе недоступна</p>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="panel panel-warning">
                <div class="panel-heading">
                    <h3 class="panel-title">Информация о курсе</h3>
                </div>
                <div class="panel-body">
                    <?php if ($model->course): ?>
                        <?= DetailView::widget([
                            'model' => $model->course,
                            'attributes' => [
                                'id',
                                'name',
                                [
                                    'attribute' => 'duration_hours',
                                    'value' => $model->course->formattedDuration,
                                ],
                                [
                                    'attribute' => 'price',
                                    'value' => $model->course->formattedPrice,
                                ],
                                [
                                    'attribute' => 'is_active',
                                    'value' => function($model) {
                                        return $model->is_active ? 'Да' : 'Нет';
                                    },
                                ],
                            ],
                        ]) ?>
                        <div class="text-center mt-3">
                            <?= Html::a('<i class="glyphicon glyphicon-education"></i> Информация о курсе', 
                                ['view-course', 'id' => $model->course->id], 
                                ['class' => 'btn btn-warning']) ?>
                        </div>
                    <?php else: ?>
                        <p class="text-muted">Информация о курсе недоступна</p>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Быстрые действия</h3>
                </div>
                <div class="panel-body">
                    <div class="list-group">
                        <?= Html::a('<i class="glyphicon glyphicon-edit"></i> Изменить статус', 
                            ['update-status', 'id' => $model->id], 
                            ['class' => 'list-group-item']) ?>
                        <?= Html::a('<i class="glyphicon glyphicon-envelope"></i> Отправить уведомление', 
                            ['#'], 
                            ['class' => 'list-group-item']) ?>
                        <?= Html::a('<i class="glyphicon glyphicon-download"></i> Скачать данные', 
                            ['#'], 
                            ['class' => 'list-group-item']) ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
@media print {
    .btn, .panel-heading .btn-group {
        display: none !important;
    }
}
</style>