<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;

$this->title = 'Управление пользователями';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="admin-users">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1><?= Html::encode($this->title) ?></h1>
        <div class="btn-group">
            <?= Html::a('<i class="glyphicon glyphicon-user"></i> Добавить пользователя', ['#'], [
                'class' => 'btn btn-success',
                'data-toggle' => 'modal',
                'data-target' => '#addUserModal'
            ]) ?>
        </div>
    </div>

    <?php Pjax::begin(); ?>
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            'id',
            'username',
            'full_name',
            'phone',
            'email',
            [
                'attribute' => 'role',
                'value' => function($model) {
                    return $model->isAdmin() ? 'Администратор' : 'Пользователь';
                },
                'filter' => [
                    'user' => 'Пользователь',
                    'admin' => 'Администратор'
                ],
            ],
            [
                'attribute' => 'created_at',
                'format' => 'datetime',
            ],
            [
                'class' => 'yii\grid\ActionColumn',
                'template' => '{view} {update}',
                'buttons' => [
                    'view' => function ($url, $model, $key) {
                        return Html::a('<i class="glyphicon glyphicon-eye-open"></i>', 
                            ['view-user', 'id' => $model->id], 
                            ['title' => 'Просмотр', 'class' => 'btn btn-xs btn-info']);
                    },
                    'update' => function ($url, $model, $key) {
                        return Html::a('<i class="glyphicon glyphicon-pencil"></i>', 
                            ['update-user', 'id' => $model->id], 
                            ['title' => 'Редактировать', 'class' => 'btn btn-xs btn-warning']);
                    },
                ],
            ],
        ],
        'tableOptions' => ['class' => 'table table-striped table-bordered'],
        'pager' => [
            'options' => ['class' => 'pagination'],
            'prevPageLabel' => '<i class="glyphicon glyphicon-chevron-left"></i>',
            'nextPageLabel' => '<i class="glyphicon glyphicon-chevron-right"></i>',
        ],
    ]); ?>
    <?php Pjax::end(); ?>

    <div class="row mt-4">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Статистика пользователей</h3>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-3 text-center">
                            <div class="well">
                                <h2><?= \app\models\User::find()->count() ?></h2>
                                <p>Всего пользователей</p>
                            </div>
                        </div>
                        <div class="col-md-3 text-center">
                            <div class="well">
                                <h2><?= \app\models\User::find()->where(['role' => 'admin'])->count() ?></h2>
                                <p>Администраторов</p>
                            </div>
                        </div>
                        <div class="col-md-3 text-center">
                            <div class="well">
                                <h2><?= \app\models\User::find()->where(['role' => 'user'])->count() ?></h2>
                                <p>Обычных пользователей</p>
                            </div>
                        </div>
                        <div class="col-md-3 text-center">
                            <div class="well">
                                <h2><?= \app\models\User::find()->where(['>=', 'created_at', date('Y-m-d', strtotime('-30 days'))])->count() ?></h2>
                                <p>Новых за 30 дней</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Модальное окно добавления пользователя -->
<div class="modal fade" id="addUserModal" tabindex="-1" role="dialog" aria-labelledby="addUserModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title" id="addUserModalLabel">Добавить пользователя</h4>
            </div>
            <div class="modal-body">
                <p class="text-muted">Для добавления пользователя используйте форму регистрации на сайте.</p>
                <p>Или попросите пользователя зарегистрироваться самостоятельно.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Закрыть</button>
                <?= Html::a('Перейти к регистрации', ['/site/register'], ['class' => 'btn btn-primary']) ?>
            </div>
        </div>
    </div>
</div>