<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Редактирование пользователя: ' . $model->full_name;
$this->params['breadcrumbs'][] = ['label' => 'Пользователи', 'url' => ['users']];
$this->params['breadcrumbs'][] = ['label' => $model->full_name, 'url' => ['view-user', 'id' => $model->id]];
$this->params['breadcrumbs'][] = 'Редактирование';
?>
<div class="admin-update-user">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <h1 class="card-title"><?= Html::encode($this->title) ?></h1>
                </div>
                <div class="card-body">
                    <div class="alert alert-warning">
                        <i class="glyphicon glyphicon-warning-sign"></i>
                        Внимание! Изменение данных пользователя может повлиять на работу системы.
                    </div>

                    <?php $form = ActiveForm::begin([
                        'id' => 'user-form',
                        'options' => ['class' => 'form-horizontal'],
                        'fieldConfig' => [
                            'template' => "{label}\n<div class=\"col-lg-12\">{input}</div>\n<div class=\"col-lg-12\">{error}</div>",
                            'labelOptions' => ['class' => 'control-label'],
                        ],
                    ]); ?>

                    <div class="row">
                        <div class="col-md-6">
                            <?= $form->field($model, 'username')->textInput(['autofocus' => true])
                                ->hint('Только латинские буквы и цифры, минимум 6 символов') ?>
                        </div>
                        <div class="col-md-6">
                            <?= $form->field($model, 'full_name')->textInput()
                                ->hint('Только кириллические символы и пробелы') ?>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <?= $form->field($model, 'phone')->textInput()
                                ->hint('Формат: 8(XXX)XXX-XX-XX') ?>
                        </div>
                        <div class="col-md-6">
                            <?= $form->field($model, 'email')->textInput()
                                ->hint('Введите действительный email адрес') ?>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <?= $form->field($model, 'role')->radioList([
                                'user' => 'Пользователь',
                                'admin' => 'Администратор'
                            ], [
                                'item' => function($index, $label, $name, $checked, $value) {
                                    $checked = $checked ? 'checked' : '';
                                    $color = $value == 'admin' ? 'danger' : 'primary';
                                    return "<div class='radio'>
                                        <label class='text-{$color}'>
                                            <input type='radio' name='{$name}' value='{$value}' {$checked}>
                                            <span class='label label-{$color}'>$label</span>
                                        </label>
                                    </div>";
                                }
                            ])->hint('Уровень доступа пользователя') ?>
                        </div>
                        <div class="col-md-6">
                            <?= $form->field($model, 'password')->passwordInput()
                                ->hint('Оставьте пустым, если не нужно менять пароль') ?>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-lg-12">
                            <?= Html::submitButton('<i class="glyphicon glyphicon-ok"></i> Сохранить изменения', ['class' => 'btn btn-primary btn-lg btn-block']) ?>
                            <?= Html::a('<i class="glyphicon glyphicon-remove"></i> Отмена', ['view-user', 'id' => $model->id], ['class' => 'btn btn-default btn-block mt-2']) ?>
                        </div>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>
            </div>
        </div>
    </div>
</div>