<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Изменение статуса заявки #' . $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Заявки', 'url' => ['applications']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="admin-update-status">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <h1 class="card-title"><?= Html::encode($this->title) ?></h1>
                </div>
                <div class="card-body">
                    <div class="application-info mb-4">
                        <h4>Информация о заявке:</h4>
                        <table class="table table-bordered">
                            <tr>
                                <th width="30%">Пользователь</th>
                                <td><?= Html::encode($model->user->full_name) ?></td>
                            </tr>
                            <tr>
                                <th>Курс</th>
                                <td><?= Html::encode($model->course_name) ?></td>
                            </tr>
                            <tr>
                                <th>Дата начала</th>
                                <td><?= Yii::$app->formatter->asDate($model->desired_start_date) ?></td>
                            </tr>
                            <tr>
                                <th>Способ оплаты</th>
                                <td><?= $model->paymentMethodLabel ?></td>
                            </tr>
                            <tr>
                                <th>Текущий статус</th>
                                <td>
                                    <span class="label label-<?= $model->statusColor ?>">
                                        <?= $model->statusLabel ?>
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <th>Дата подачи</th>
                                <td><?= Yii::$app->formatter->asDatetime($model->created_at) ?></td>
                            </tr>
                        </table>
                    </div>

                    <?php $form = ActiveForm::begin([
                        'id' => 'status-form',
                        'options' => ['class' => 'form-horizontal'],
                        'fieldConfig' => [
                            'template' => "{label}\n<div class=\"col-lg-12\">{input}</div>\n<div class=\"col-lg-12\">{error}</div>",
                            'labelOptions' => ['class' => 'control-label'],
                        ],
                    ]); ?>

                    <div class="row">
                        <div class="col-md-12">
                            <?= $form->field($model, 'status')->radioList(
                                \app\models\Application::getStatusLabels(),
                                [
                                    'item' => function($index, $label, $name, $checked, $value) {
                                        $checked = $checked ? 'checked' : '';
                                        $colors = [
                                            'new' => 'primary',
                                            'in_progress' => 'warning',
                                            'completed' => 'success',
                                            'rejected' => 'danger'
                                        ];
                                        $color = $colors[$value] ?? 'default';
                                        return "<div class='radio'>
                                            <label class='text-{$color}'>
                                                <input type='radio' name='{$name}' value='{$value}' {$checked}>
                                                <span class='label label-{$color}'>$label</span>
                                            </label>
                                        </div>";
                                    }
                                ]
                            )->label('Новый статус*') ?>
                        </div>
                    </div>

                    <?php if ($model->status === \app\models\Application::STATUS_COMPLETED): ?>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="alert alert-info">
                                <i class="glyphicon glyphicon-info-sign"></i>
                                При установке статуса "Обучение завершено", пользователь сможет оставить отзыв о курсе.
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                    <div class="row">
                        <div class="col-md-12">
                            <?= $form->field($model, 'feedback')->textarea(['rows' => 4])
                                ->label('Комментарий администратора')
                                ->hint('Необязательное поле. Комментарий виден только администраторам.') ?>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-lg-12">
                            <?= Html::submitButton('<i class="glyphicon glyphicon-ok"></i> Сохранить статус', ['class' => 'btn btn-primary btn-lg btn-block']) ?>
                            <?= Html::a('<i class="glyphicon glyphicon-arrow-left"></i> Вернуться к заявкам', ['applications'], ['class' => 'btn btn-default btn-block mt-2']) ?>
                        </div>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>
            </div>
        </div>
    </div>
</div>