<?php

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Панель администратора';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="admin-index">
    <h1><?= Html::encode($this->title) ?></h1>
    
    <div class="alert alert-info">
        <i class="glyphicon glyphicon-info-sign"></i>
        Добро пожаловать в панель администратора. Здесь вы можете управлять заявками, пользователями и курсами.
    </div>

    <div class="row mb-4">
        <div class="col-md-3 col-sm-6">
            <div class="panel panel-primary">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-xs-3">
                            <i class="glyphicon glyphicon-list-alt fa-5x"></i>
                        </div>
                        <div class="col-xs-9 text-right">
                            <div class="huge"><?= $stats['total_applications'] ?></div>
                            <div>Всего заявок</div>
                        </div>
                    </div>
                </div>
                <?= Html::a('
                    <div class="panel-footer">
                        <span class="pull-left">Подробнее</span>
                        <span class="pull-right"><i class="glyphicon glyphicon-arrow-right"></i></span>
                        <div class="clearfix"></div>
                    </div>
                ', ['applications'], ['class' => 'panel-footer-link']) ?>
            </div>
        </div>
        
        <div class="col-md-3 col-sm-6">
            <div class="panel panel-green">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-xs-3">
                            <i class="glyphicon glyphicon-user fa-5x"></i>
                        </div>
                        <div class="col-xs-9 text-right">
                            <div class="huge"><?= $stats['total_users'] ?></div>
                            <div>Пользователей</div>
                        </div>
                    </div>
                </div>
                <?= Html::a('
                    <div class="panel-footer">
                        <span class="pull-left">Подробнее</span>
                        <span class="pull-right"><i class="glyphicon glyphicon-arrow-right"></i></span>
                        <div class="clearfix"></div>
                    </div>
                ', ['users'], ['class' => 'panel-footer-link']) ?>
            </div>
        </div>
        
        <div class="col-md-3 col-sm-6">
            <div class="panel panel-yellow">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-xs-3">
                            <i class="glyphicon glyphicon-education fa-5x"></i>
                        </div>
                        <div class="col-xs-9 text-right">
                            <div class="huge"><?= $stats['total_courses'] ?></div>
                            <div>Курсов</div>
                        </div>
                    </div>
                </div>
                <?= Html::a('
                    <div class="panel-footer">
                        <span class="pull-left">Подробнее</span>
                        <span class="pull-right"><i class="glyphicon glyphicon-arrow-right"></i></span>
                        <div class="clearfix"></div>
                    </div>
                ', ['courses'], ['class' => 'panel-footer-link']) ?>
            </div>
        </div>
        
        <div class="col-md-3 col-sm-6">
            <div class="panel panel-red">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-xs-3">
                            <i class="glyphicon glyphicon-star fa-5x"></i>
                        </div>
                        <div class="col-xs-9 text-right">
                            <div class="huge"><?= $stats['completed_applications'] ?></div>
                            <div>Завершено</div>
                        </div>
                    </div>
                </div>
                <?= Html::a('
                    <div class="panel-footer">
                        <span class="pull-left">Подробнее</span>
                        <span class="pull-right"><i class="glyphicon glyphicon-arrow-right"></i></span>
                        <div class="clearfix"></div>
                    </div>
                ', ['applications'], ['class' => 'panel-footer-link']) ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Статистика по заявкам</h3>
                </div>
                <div class="panel-body">
                    <table class="table table-bordered">
                        <tr>
                            <th>Статус</th>
                            <th>Количество</th>
                            <th>Процент</th>
                        </tr>
                        <?php 
                        $total = $stats['total_applications'];
                        $statuses = [
                            'Новые' => $stats['new_applications'],
                            'В процессе' => $stats['in_progress_applications'],
                            'Завершено' => $stats['completed_applications']
                        ];
                        ?>
                        <?php foreach ($statuses as $status => $count): ?>
                            <?php $percentage = $total > 0 ? round(($count / $total) * 100, 1) : 0; ?>
                            <tr>
                                <td><?= $status ?></td>
                                <td><?= $count ?></td>
                                <td>
                                    <div class="progress" style="margin-bottom: 0;">
                                        <div class="progress-bar progress-bar-<?= 
                                            $status == 'Новые' ? 'info' : 
                                            ($status == 'В процессе' ? 'warning' : 'success') 
                                        ?>" role="progressbar" 
                                             style="width: <?= $percentage ?>%;"
                                             aria-valuenow="<?= $percentage ?>" 
                                             aria-valuemin="0" 
                                             aria-valuemax="100">
                                            <?= $percentage ?>%
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Последние заявки</h3>
                </div>
                <div class="panel-body">
                    <?php if (empty($recentApplications)): ?>
                        <p class="text-muted">Нет заявок</p>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Пользователь</th>
                                        <th>Курс</th>
                                        <th>Статус</th>
                                        <th>Дата</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($recentApplications as $application): ?>
                                    <tr>
                                        <td><?= $application->id ?></td>
                                        <td><?= Html::encode($application->user->full_name) ?></td>
                                        <td><?= Html::encode($application->course_name) ?></td>
                                        <td>
                                            <span class="label label-<?= $application->statusColor ?>">
                                                <?= $application->statusLabel ?>
                                            </span>
                                        </td>
                                        <td><?= Yii::$app->formatter->asDate($application->created_at, 'short') ?></td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Быстрые действия</h3>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="well text-center">
                                <i class="glyphicon glyphicon-plus-sign fa-3x text-success mb-3"></i>
                                <h4>Добавить курс</h4>
                                <p>Создать новый курс для обучения</p>
                                <?= Html::a('Добавить курс', ['create-course'], ['class' => 'btn btn-success']) ?>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="well text-center">
                                <i class="glyphicon glyphicon-eye-open fa-3x text-primary mb-3"></i>
                                <h4>Просмотр заявок</h4>
                                <p>Просмотр и управление всеми заявками</p>
                                <?= Html::a('Просмотр заявок', ['applications'], ['class' => 'btn btn-primary']) ?>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="well text-center">
                                <i class="glyphicon glyphicon-stats fa-3x text-warning mb-3"></i>
                                <h4>Статистика</h4>
                                <p>Подробная статистика системы</p>
                                <?= Html::a('Статистика', ['#'], ['class' => 'btn btn-warning']) ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.panel-footer-link {
    display: block;
    color: #777;
    text-decoration: none;
}

.panel-footer-link:hover {
    text-decoration: none;
    background-color: #f5f5f5;
}

.panel-primary .panel-footer-link:hover {
    background-color: #286090;
    color: white;
}

.panel-green {
    border-color: #5cb85c;
}

.panel-green .panel-heading {
    border-color: #5cb85c;
    color: white;
    background-color: #5cb85c;
}

.panel-green .panel-footer-link:hover {
    background-color: #449d44;
    color: white;
}

.panel-yellow {
    border-color: #f0ad4e;
}

.panel-yellow .panel-heading {
    border-color: #f0ad4e;
    color: white;
    background-color: #f0ad4e;
}

.panel-yellow .panel-footer-link:hover {
    background-color: #ec971f;
    color: white;
}

.panel-red {
    border-color: #d9534f;
}

.panel-red .panel-heading {
    border-color: #d9534f;
    color: white;
    background-color: #d9534f;
}

.panel-red .panel-footer-link:hover {
    background-color: #c9302c;
    color: white;
}

.huge {
    font-size: 40px;
}
</style>