<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;

$this->title = 'Управление курсами';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="admin-courses">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1><?= Html::encode($this->title) ?></h1>
        <div class="btn-group">
            <?= Html::a('<i class="glyphicon glyphicon-plus"></i> Добавить курс', ['create-course'], ['class' => 'btn btn-success']) ?>
        </div>
    </div>

    <?php Pjax::begin(); ?>
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            'id',
            'name',
            [
                'attribute' => 'duration_hours',
                'value' => function($model) {
                    return $model->duration_hours ? $model->duration_hours . ' часов' : 'Не указано';
                },
            ],
            [
                'attribute' => 'price',
                'value' => function($model) {
                    return $model->price ? Yii::$app->formatter->asCurrency($model->price) : 'Бесплатно';
                },
            ],
            [
                'attribute' => 'is_active',
                'value' => function($model) {
                    return $model->is_active ? 
                        '<span class="label label-success">Активен</span>' : 
                        '<span class="label label-danger">Не активен</span>';
                },
                'format' => 'raw',
                'filter' => [
                    1 => 'Активен',
                    0 => 'Не активен'
                ],
            ],
            [
                'attribute' => 'applicationsCount',
                'label' => 'Заявок',
                'value' => function($model) {
                    return $model->getApplicationsCount();
                },
            ],
            [
                'class' => 'yii\grid\ActionColumn',
                'template' => '{view} {update} {delete}',
                'buttons' => [
                    'view' => function ($url, $model, $key) {
                        return Html::a('<i class="glyphicon glyphicon-eye-open"></i>', 
                            ['view-course', 'id' => $model->id], 
                            ['title' => 'Просмотр', 'class' => 'btn btn-xs btn-info']);
                    },
                    'update' => function ($url, $model, $key) {
                        return Html::a('<i class="glyphicon glyphicon-pencil"></i>', 
                            ['update-course', 'id' => $model->id], 
                            ['title' => 'Редактировать', 'class' => 'btn btn-xs btn-warning']);
                    },
                    'delete' => function ($url, $model, $key) {
                        return Html::a('<i class="glyphicon glyphicon-trash"></i>', 
                            ['delete-course', 'id' => $model->id], 
                            [
                                'title' => 'Удалить',
                                'class' => 'btn btn-xs btn-danger',
                                'data' => [
                                    'confirm' => 'Вы уверены, что хотите удалить этот курс?',
                                    'method' => 'post',
                                ],
                            ]);
                    },
                ],
            ],
        ],
        'tableOptions' => ['class' => 'table table-striped table-bordered'],
        'pager' => [
            'options' => ['class' => 'pagination'],
            'prevPageLabel' => '<i class="glyphicon glyphicon-chevron-left"></i>',
            'nextPageLabel' => '<i class="glyphicon glyphicon-chevron-right"></i>',
        ],
    ]); ?>
    <?php Pjax::end(); ?>

    <div class="row mt-4">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Статистика курсов</h3>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-3 text-center">
                            <div class="well">
                                <h2><?= \app\models\Course::find()->count() ?></h2>
                                <p>Всего курсов</p>
                            </div>
                        </div>
                        <div class="col-md-3 text-center">
                            <div class="well">
                                <h2><?= \app\models\Course::find()->where(['is_active' => true])->count() ?></h2>
                                <p>Активных курсов</p>
                            </div>
                        </div>
                        <div class="col-md-3 text-center">
                            <div class="well">
                                <h2><?= \app\models\Application::find()->count() ?></h2>
                                <p>Всего заявок</p>
                            </div>
                        </div>
                        <div class="col-md-3 text-center">
                            <div class="well">
                                <h2>
                                    <?php 
                                    $totalPrice = \app\models\Course::find()
                                        ->select('SUM(price) as total')
                                        ->scalar();
                                    echo Yii::$app->formatter->asCurrency($totalPrice ?: 0);
                                    ?>
                                </h2>
                                <p>Общая стоимость</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>