<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%courses}}`.
 */
class m251221_093957_create_courses_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%courses}}', [
            'id' => $this->primaryKey(),
            'name' => $this->string(200)->notNull(),
            'description' => $this->text(),
            'duration_hours' => $this->integer(),
            'price' => $this->decimal(10, 2),
            'is_active' => $this->boolean()->defaultValue(true),
            'created_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP'),
            'updated_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
        ]);

        $courses = [
            [
                'name' => 'Веб-разработка на PHP и Yii2',
                'description' => 'Полный курс по разработке веб-приложений на PHP и фреймворке Yii2',
                'duration_hours' => 120,
                'price' => 25000.00
            ],
            [
                'name' => 'JavaScript продвинутый уровень',
                'description' => 'Углубленное изучение JavaScript, ES6+, TypeScript и современных фреймворков',
                'duration_hours' => 90,
                'price' => 30000.00
            ],
            [
                'name' => 'Дизайн интерфейсов UX/UI',
                'description' => 'Курс по UX/UI дизайну, проектированию и созданию пользовательских интерфейсов',
                'duration_hours' => 80,
                'price' => 28000.00
            ],
            [
                'name' => 'Основы Python для начинающих',
                'description' => 'Введение в программирование на Python, основы синтаксиса и практические задачи',
                'duration_hours' => 60,
                'price' => 20000.00
            ],
            [
                'name' => 'Базы данных и SQL',
                'description' => 'Курс по проектированию, нормализации и работе с реляционными базами данных',
                'duration_hours' => 70,
                'price' => 22000.00
            ],
            [
                'name' => 'Мобильная разработка на React Native',
                'description' => 'Создание кроссплатформенных мобильных приложений на React Native',
                'duration_hours' => 100,
                'price' => 32000.00
            ],
        ];

        foreach ($courses as $course) {
            $this->insert('{{%courses}}', $course);
        }
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%courses}}');
    }
}
